/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.backup.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tp_link.eap.configuration.Configuration;
import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.domain.cloud.ModelFw;
import com.tp_link.eap.domain.eap.AlertInfo;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.Client;
import com.tp_link.eap.domain.eap.ClientHistory;
import com.tp_link.eap.domain.eap.LogInfo;
import com.tp_link.eap.domain.eap.Map;
import com.tp_link.eap.domain.eap.RogueAp;
import com.tp_link.eap.domain.eap.StatLifeClient;
import com.tp_link.eap.domain.eap.StatRADaily;
import com.tp_link.eap.domain.eap.StatRAHourly;
import com.tp_link.eap.domain.eap.bean.LoadBalance;
import com.tp_link.eap.domain.eap.bean.Radio;
import com.tp_link.eap.domain.eap.bean.SsidOverride;
import com.tp_link.eap.domain.email.MailServer;
import com.tp_link.eap.domain.globalsetting.AccessSubnetGroup;
import com.tp_link.eap.domain.globalsetting.BandSteering;
import com.tp_link.eap.domain.globalsetting.FreeAuthenticationPolicy;
import com.tp_link.eap.domain.globalsetting.GlobalEnable;
import com.tp_link.eap.domain.globalsetting.HistoryRetentionSetting;
import com.tp_link.eap.domain.globalsetting.LogSetting;
import com.tp_link.eap.domain.globalsetting.ManagementVlanSetting;
import com.tp_link.eap.domain.globalsetting.PortalSetting;
import com.tp_link.eap.domain.globalsetting.Profile;
import com.tp_link.eap.domain.globalsetting.QosSetting;
import com.tp_link.eap.domain.globalsetting.SshSetting;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.StationMacList;
import com.tp_link.eap.domain.globalsetting.UserAccountSetting;
import com.tp_link.eap.domain.globalsetting.Wireless;
import com.tp_link.eap.domain.globalsetting.WlanGroup;
import com.tp_link.eap.domain.hotspot.LocalUser;
import com.tp_link.eap.domain.hotspot.Operator;
import com.tp_link.eap.domain.hotspot.Voucher;
import com.tp_link.eap.domain.mesh.document.MeshSetting;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.domain.portal.PortalWebUIPicture;
import com.tp_link.eap.domain.scheduler.Schedule;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.domain.site.Site;
import com.tp_link.eap.monitor.backup.b;
import com.tp_link.eap.monitor.cloudkey.model.CloudKeyEntry;
import com.tp_link.eap.monitor.cloudkey.service.a;
import com.tp_link.eap.monitor.globalsetting.service.j;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.globalsetting.service.m;
import com.tp_link.eap.monitor.globalsetting.service.n;
import com.tp_link.eap.monitor.monitor.service.d;
import com.tp_link.eap.monitor.monitor.service.f;
import com.tp_link.eap.monitor.monitor.service.i;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.service.CSSettingService;
import com.tp_link.eap.user.service.MailServerService;
import com.tp_link.eap.util.e;
import com.tp_link.eap.util.e.c;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="backupService")
public class BackupServiceImpl
implements b {
    private static final Logger b = LoggerFactory.getLogger(BackupServiceImpl.class);
    private static final String c = "eapc_backup";
    private static final int d = 1000;
    private static boolean e = false;
    @Autowired
    protected MongoTemplate a;
    @Autowired
    private f f;
    @Autowired
    private n g;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.c h;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.d i;
    @Autowired
    private m j;
    @Autowired
    private l k;
    @Autowired
    private j l;
    @Autowired
    private CSSettingService m;
    @Autowired
    private MailServerService n;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b o;
    @Autowired
    private i p;
    @Autowired
    private d q;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.i r;
    @Autowired
    private a s;

    @Override
    public OperationResponse backup(HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        OperationResponse operationResponse;
        if (e) {
            return new OperationResponse(ResErrorCode.ci);
        }
        e = true;
        long l2 = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String string = simpleDateFormat.format(l2);
        String string2 = "eapc_backup(" + string + ").cfg";
        try (ServletOutputStream servletOutputStream = response.getOutputStream();){
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "max-age:3");
            response.setHeader("Content-Disposition", "attachment;fileName=" + string2);
            JSONObject jSONObject = reqObj.optJSONObject("params");
            int n2 = jSONObject.optInt("retention");
            operationResponse = this.a((OutputStream)servletOutputStream, n2, l2);
        }
        catch (IOException iOException) {
            b.warn(iOException.toString(), (Throwable)iOException);
            e = false;
            return new OperationResponse(ResErrorCode.b);
        }
        e = false;
        return operationResponse;
    }

    @Override
    public OperationResponse a(OutputStream outputStream, int n2, long l2) {
        try (CipherOutputStream cipherOutputStream = com.tp_link.eap.util.e.c.a((OutputStream)outputStream);
             GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)cipherOutputStream);
             JsonGenerator jsonGenerator = new JsonFactory().createGenerator((OutputStream)gZIPOutputStream, JsonEncoding.UTF8);){
            jsonGenerator.setCodec((ObjectCodec)new ObjectMapper());
            jsonGenerator.writeStartObject();
            this.a(jsonGenerator);
            this.b(jsonGenerator);
            this.g(jsonGenerator);
            this.c(jsonGenerator);
            this.d(jsonGenerator);
            this.e(jsonGenerator);
            this.f(jsonGenerator);
            this.h(jsonGenerator);
            this.i(jsonGenerator);
            this.j(jsonGenerator);
            this.k(jsonGenerator);
            this.l(jsonGenerator);
            this.m(jsonGenerator);
            this.n(jsonGenerator);
            this.o(jsonGenerator);
            this.p(jsonGenerator);
            this.q(jsonGenerator);
            this.r(jsonGenerator);
            this.s(jsonGenerator);
            if (n2 >= 0) {
                this.a(jsonGenerator, n2, l2);
                this.b(jsonGenerator, n2, l2);
                this.a(jsonGenerator, n2);
                this.b(jsonGenerator, n2);
                this.c(jsonGenerator, n2, l2);
                this.d(jsonGenerator, n2, l2);
                this.e(jsonGenerator, n2, l2);
            }
            if (!com.tp_link.eap.util.l.b()) {
                this.t(jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (IOException iOException) {
            b.warn(iOException.toString(), (Throwable)iOException);
            return new OperationResponse(ResErrorCode.b);
        }
        return com.tp_link.eap.util.e.bd;
    }

    private void a(JsonGenerator jsonGenerator) throws IOException {
        Configuration configuration = com.tp_link.eap.configuration.a.a((String)"eap.properties");
        String string = configuration.getProperty("eap.version");
        jsonGenerator.writeStringField("ver", string);
    }

    private void b(JsonGenerator jsonGenerator) throws IOException {
        List list = this.a.findAll(Site.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            jsonGenerator.writeObjectField("site", (Object)list);
        }
    }

    private void c(JsonGenerator jsonGenerator) throws IOException {
        List list = this.a.findAll(Privilege.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            jsonGenerator.writeObjectField("privilege", (Object)list);
        }
    }

    private void d(JsonGenerator jsonGenerator) throws IOException {
        List<ModelFw> list = this.f.getByCategory(ModelFw.DeviceCategory.EAP.getCategory());
        if (!CollectionUtils.isEmpty(list)) {
            jsonGenerator.writeObjectField("modelFirmware", list);
        }
    }

    private void e(JsonGenerator jsonGenerator) throws IOException {
        Object object2;
        List list = this.a.findAll(Site.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        jsonGenerator.writeArrayFieldStart("globalSetting");
        for (Object object2 : list) {
            BandSteering bandSteering;
            LogSetting logSetting;
            Wireless wireless;
            GlobalEnable globalEnable;
            List<PortalSetting> list2;
            List<Profile> list3;
            List<StationMacList> list4;
            ManagementVlanSetting managementVlanSetting;
            SshSetting sshSetting;
            UserAccountSetting userAccountSetting;
            List<FreeAuthenticationPolicy> list5;
            jsonGenerator.writeStartObject();
            String string = object2.getSiteName();
            com.tp_link.eap.d.b.b((String)string);
            List<WlanGroup> list6 = this.g.getAllBySite();
            if (!CollectionUtils.isEmpty(list6)) {
                jsonGenerator.writeObjectField("wlanGroup", list6);
            }
            if (!CollectionUtils.isEmpty(list5 = this.h.getAllBySite(object2.getSiteName()))) {
                jsonGenerator.writeObjectField("fap", list5);
            }
            if (null != (userAccountSetting = this.i.getUserAccountSetting())) {
                jsonGenerator.writeObjectField("userAccount", (Object)userAccountSetting);
            }
            if (null != (sshSetting = this.i.getSshSetting())) {
                jsonGenerator.writeObjectField("ssh", (Object)sshSetting);
            }
            if (null != (managementVlanSetting = this.i.getManagementVlanSetting())) {
                jsonGenerator.writeObjectField("managementVlan", (Object)managementVlanSetting);
            }
            if (!CollectionUtils.isEmpty(list4 = this.j.getAllBySite(object2.getSiteName()))) {
                jsonGenerator.writeObjectField("station", list4);
            }
            if (!CollectionUtils.isEmpty(list3 = this.l.getAllBySite(object2.getSiteName()))) {
                jsonGenerator.writeObjectField("profile", list3);
            }
            this.a(jsonGenerator, (Site)object2);
            QosSetting qosSetting = this.i.getQosSetting();
            if (null != qosSetting) {
                jsonGenerator.writeObjectField("qos", (Object)qosSetting);
            }
            if (!CollectionUtils.isEmpty(list2 = this.i.getPortalSettingList())) {
                jsonGenerator.writeObjectField("portalList", list2);
            }
            if (null != (globalEnable = this.i.getGlobalEnbale())) {
                jsonGenerator.writeObjectField("globalEnable", (Object)globalEnable);
            }
            if (null != (wireless = this.i.getWirelessSetting())) {
                jsonGenerator.writeObjectField("wireless", (Object)wireless);
            }
            if (null != (logSetting = this.i.getLogSetting())) {
                jsonGenerator.writeObjectField("log", (Object)logSetting);
            }
            if (null != (bandSteering = this.i.getBandSteering())) {
                jsonGenerator.writeObjectField("bandSteering", (Object)bandSteering);
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        List<MeshSetting> list7 = this.i.getMeshSettingList();
        if (!CollectionUtils.isEmpty((Collection)list7)) {
            jsonGenerator.writeObjectField("mesh", (Object)list7);
        }
        if (!CollectionUtils.isEmpty((Collection)(object2 = this.i.getRoamingSettingList()))) {
            jsonGenerator.writeObjectField("roaming", object2);
        }
    }

    private void a(JsonGenerator jsonGenerator, Site site) throws IOException {
        List<Ssid> list = this.k.getAllBySite(site.getSiteName());
        if (!CollectionUtils.isEmpty(list)) {
            for (Ssid ssid : list) {
                StationMacList stationMacList;
                if (null != ssid.getMacFilterId() && null != (stationMacList = this.j.getById(ssid.getMacFilterId()))) {
                    ssid.setFilterName(stationMacList.getName());
                }
                if (null != ssid.getSchedulerId() && null != (stationMacList = this.l.getById(ssid.getSchedulerId()))) {
                    ssid.setSchedulerName(stationMacList.getName());
                }
                if (null == ssid.getWlanId() || null == (stationMacList = this.g.getByWlanId(ssid.getWlanId()))) continue;
                ssid.setWlanName(stationMacList.getName());
            }
            jsonGenerator.writeObjectField("ssid", list);
        }
    }

    private void f(JsonGenerator jsonGenerator) throws IOException {
        HistoryRetentionSetting historyRetentionSetting = this.i.getHistoryRetentionSetting();
        if (null != historyRetentionSetting) {
            jsonGenerator.writeObjectField("historyRetention", (Object)historyRetentionSetting);
        }
    }

    private void g(JsonGenerator jsonGenerator) throws IOException {
        MailServer mailServer;
        Object object;
        List list = this.a.findAll(User.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            jsonGenerator.writeArrayFieldStart("user");
            object = list.iterator();
            while (object.hasNext()) {
                mailServer = (User)object.next();
                if (mailServer.isDefault()) continue;
                jsonGenerator.writeObject((Object)mailServer);
            }
            jsonGenerator.writeEndArray();
        }
        if (null != (object = this.m.getCSSetting())) {
            jsonGenerator.writeObjectField("controllerSetting", object);
        }
        if (null != (mailServer = this.n.getMailServer())) {
            jsonGenerator.writeObjectField("mailServer", (Object)mailServer);
        }
    }

    private void h(JsonGenerator jsonGenerator) throws IOException {
        List list = this.a.findAll(Schedule.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            jsonGenerator.writeObjectField("schedule", (Object)list);
        }
    }

    private void i(JsonGenerator jsonGenerator) throws IOException {
        List<Ap> list = this.o.getAdoptAps();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        jsonGenerator.writeArrayFieldStart("ap");
        for (Ap ap : list) {
            SsidOverride ssidOverride;
            Object object;
            List list2;
            LoadBalance loadBalance;
            LoadBalance loadBalance2;
            Radio radio;
            Radio radio2;
            jsonGenerator.writeStartObject();
            if (null != ap.getMac()) {
                jsonGenerator.writeStringField("mac", ap.getMac());
            }
            if (null != ap.getName()) {
                jsonGenerator.writeStringField("name", ap.getName());
            }
            if (null != ap.getSite()) {
                jsonGenerator.writeStringField("site", ap.getSite());
            }
            if (null != ap.getWlanGroupId2G() && null != ap.getWlan2g()) {
                jsonGenerator.writeStringField("wlanGroupId2G", ap.getWlanGroupId2G());
                jsonGenerator.writeStringField("wlan2g", ap.getWlan2g());
            }
            if (null != ap.getWlanGroupId5G() && null != ap.getWlan5g()) {
                jsonGenerator.writeStringField("wlanGroupId5G", ap.getWlanGroupId5G());
                jsonGenerator.writeStringField("wlan5g", ap.getWlan5g());
            }
            if (null != ap.getIp()) {
                jsonGenerator.writeStringField("ip", ap.getIp());
            }
            if (null != ap.getModel()) {
                jsonGenerator.writeStringField("model", ap.getModel());
            }
            if (null != ap.getVersion()) {
                jsonGenerator.writeStringField("version", ap.getVersion());
            }
            if (null != ap.getModelVersion()) {
                jsonGenerator.writeStringField("modelVersion", ap.getModelVersion());
            }
            if (null != ap.getModelModelVersion()) {
                jsonGenerator.writeStringField("modelModelVersion", ap.getModelModelVersion());
            }
            if (null != ap.getHwVersion()) {
                jsonGenerator.writeStringField("hwVersion", ap.getHwVersion());
            }
            if (null != ap.getAdoptInfo()) {
                jsonGenerator.writeObjectField("adoptInfo", (Object)ap.getAdoptInfo());
            }
            if (null != ap.getDeviceMisc()) {
                jsonGenerator.writeObjectField("deviceMisc", (Object)ap.getDeviceMisc());
            }
            if (null != ap.getIpSetting()) {
                jsonGenerator.writeObjectField("ipSetting", (Object)ap.getIpSetting());
            }
            if (null != ap.getLanPortSettings()) {
                jsonGenerator.writeObjectField("lanPortSettings", (Object)ap.getLanPortSettings());
            }
            if (null != (radio2 = ap.getRadio())) {
                radio2.setRadioId(0);
                jsonGenerator.writeObjectField("radio", (Object)radio2);
            }
            if (null != (radio = ap.getRadio5g())) {
                radio.setRadioId(1);
                jsonGenerator.writeObjectField("radio5g", (Object)radio);
            }
            if (null != (loadBalance2 = ap.getLoadBalance())) {
                loadBalance2.setRadioId(0);
                jsonGenerator.writeObjectField("loadBalance", (Object)loadBalance2);
            }
            if (null != (loadBalance = ap.getLoadBalance5g())) {
                loadBalance.setRadioId(1);
                jsonGenerator.writeObjectField("loadBalance5g", (Object)loadBalance);
            }
            if (!CollectionUtils.isEmpty((Collection)(list2 = ap.getSsidOverrides()))) {
                object = list2.iterator();
                while (object.hasNext()) {
                    ssidOverride = (SsidOverride)object.next();
                    ssidOverride.setRadioId(0);
                }
                jsonGenerator.writeObjectField("ssidOverrides", (Object)list2);
            }
            if (!CollectionUtils.isEmpty((Collection)(object = ap.getSsidOverrides5g()))) {
                ssidOverride = object.iterator();
                while (ssidOverride.hasNext()) {
                    SsidOverride ssidOverride2 = (SsidOverride)ssidOverride.next();
                    ssidOverride2.setRadioId(1);
                }
                jsonGenerator.writeObjectField("ssidOverrides5g", object);
            }
            jsonGenerator.writeBooleanField("rogueStatus", ap.isRogueStatus());
            if (null != ap.getRssi()) {
                jsonGenerator.writeObjectField("rssi", (Object)ap.getRssi());
            }
            if (null != ap.getRssi5g()) {
                jsonGenerator.writeObjectField("rssi5g", (Object)ap.getRssi5g());
            }
            if (null != ap.getTrunkSetting()) {
                jsonGenerator.writeObjectField("trunkSetting", (Object)ap.getTrunkSetting());
            }
            if (null != ap.getWirelessLinked()) {
                jsonGenerator.writeBooleanField("wirelessLinked", ap.getWirelessLinked().booleanValue());
            }
            if (null != ap.getControllerSetting()) {
                jsonGenerator.writeObjectField("controllerSetting", (Object)ap.getControllerSetting());
            }
            if (null != ap.getLocation()) {
                jsonGenerator.writeObjectField("location", (Object)ap.getLocation());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
    }

    private void j(JsonGenerator jsonGenerator) throws IOException {
        List<Ap> list = this.o.getAdoptAps();
        jsonGenerator.writeArrayFieldStart("apAssociation");
        for (Ap ap : list) {
            Profile profile;
            if (null == ap.getSchedulerId() || ap.getSchedulerId() <= 0 || null == (profile = this.l.getById(ap.getSchedulerId()))) continue;
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("apMac", ap.getMac());
            jsonGenerator.writeStringField("profileName", profile.getName());
            jsonGenerator.writeBooleanField("schedulerAction", ap.getSchedulerAction().booleanValue());
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
    }

    private void k(JsonGenerator jsonGenerator) throws IOException {
        int n2;
        Query query = new Query().addCriteria(Criteria.where((String)"isTrusted").is((Object)true));
        long l2 = this.a.count(query, RogueAp.class);
        if (0L == l2) {
            return;
        }
        long l3 = l2 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("rogue");
        int n3 = 0;
        while ((long)n3 < l3 && 0 != (n2 = Math.min(1000, (int)(l2 - (long)(n3 * 1000))))) {
            query.with((Pageable)new PageRequest(n3, Math.min(1000, n2)));
            List list = this.a.find(query, RogueAp.class);
            for (RogueAp rogueAp : list) {
                jsonGenerator.writeObject((Object)rogueAp);
            }
            ++n3;
        }
        jsonGenerator.writeEndArray();
    }

    private void l(JsonGenerator jsonGenerator) throws IOException {
        int n2;
        Query query = new Query().addCriteria(Criteria.where((String)"isBlock").is((Object)true));
        long l2 = this.a.count(query, Client.class);
        if (0L == l2) {
            return;
        }
        long l3 = l2 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("blockClients");
        int n3 = 0;
        while ((long)n3 < l3 && 0 != (n2 = Math.min(1000, (int)(l2 - (long)(n3 * 1000))))) {
            query.with((Pageable)new PageRequest(n3, Math.min(1000, n2)));
            List list = this.a.find(query, Client.class);
            for (Client client : list) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("mac", client.getMac());
                jsonGenerator.writeStringField("site", client.getSite());
                jsonGenerator.writeNumberField("lastSeen", client.getLastSeen().longValue());
                jsonGenerator.writeEndObject();
            }
            ++n3;
        }
        jsonGenerator.writeEndArray();
    }

    private void m(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeArrayFieldStart("rateLimitClients");
        List list = this.a.findAll(Site.class);
        for (Site site : list) {
            List<Client> list2 = this.q.getRateLimitClientsBySite(site.getSiteName());
            if (CollectionUtils.isEmpty(list2)) continue;
            for (Client client : list2) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("mac", client.getMac());
                jsonGenerator.writeStringField("site", client.getSite());
                jsonGenerator.writeNumberField("lastSeen", client.getLastSeen().longValue());
                jsonGenerator.writeObjectField("clientRateLimitSetting", (Object)client.getClientRateLimitSetting());
                jsonGenerator.writeEndObject();
            }
        }
        jsonGenerator.writeEndArray();
    }

    private void n(JsonGenerator jsonGenerator) throws IOException {
        List list = this.a.findAll(AccessSubnetGroup.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            jsonGenerator.writeObjectField("accessSubnetGroups", (Object)list);
        }
    }

    private void o(JsonGenerator jsonGenerator) throws IOException {
        int n2;
        Query query = new Query();
        long l2 = this.a.count(query, Operator.class);
        if (0L == l2) {
            return;
        }
        long l3 = l2 / 1000L + 1L;
        jsonGenerator.writeFieldName("hotspot");
        jsonGenerator.writeStartObject();
        jsonGenerator.writeArrayFieldStart("operator");
        int n3 = 0;
        while ((long)n3 < l3 && 0 != (n2 = Math.min(1000, (int)(l2 - (long)(n3 * 1000))))) {
            query.with((Pageable)new PageRequest(n3, Math.min(1000, n2)));
            List list = this.a.find(query, Operator.class);
            for (Operator operator : list) {
                jsonGenerator.writeObject((Object)operator);
            }
            ++n3;
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    private void p(JsonGenerator jsonGenerator) throws IOException {
        int n2;
        Query query = new Query();
        long l2 = this.a.count(query, LocalUser.class);
        if (0L == l2) {
            return;
        }
        long l3 = l2 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("localUser");
        int n3 = 0;
        while ((long)n3 < l3 && 0 != (n2 = Math.min(1000, (int)(l2 - (long)(n3 * 1000))))) {
            query.with((Pageable)new PageRequest(n3, Math.min(1000, n2)));
            List list = this.a.find(query, LocalUser.class);
            for (LocalUser localUser : list) {
                jsonGenerator.writeObject((Object)localUser);
            }
            ++n3;
        }
        jsonGenerator.writeEndArray();
    }

    private void q(JsonGenerator jsonGenerator) throws IOException {
        int n2;
        Query query = new Query();
        long l2 = this.a.count(query, Voucher.class);
        if (0L == l2) {
            return;
        }
        long l3 = l2 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("voucher");
        int n3 = 0;
        while ((long)n3 < l3 && 0 != (n2 = Math.min(1000, (int)(l2 - (long)(n3 * 1000))))) {
            query.with((Pageable)new PageRequest(n3, Math.min(1000, n2)));
            List list = this.a.find(query, Voucher.class);
            for (Voucher voucher : list) {
                jsonGenerator.writeObject((Object)voucher);
            }
            ++n3;
        }
        jsonGenerator.writeEndArray();
    }

    private void r(JsonGenerator jsonGenerator) throws IOException {
        List<PortalWebUIPicture> list = this.r.getFormalPictureRecords();
        if (!CollectionUtils.isEmpty(list)) {
            jsonGenerator.writeObjectField("portalImg", list);
            jsonGenerator.writeArrayFieldStart("portalImgFile");
            for (PortalWebUIPicture portalWebUIPicture : list) {
                jsonGenerator.writeStartObject();
                String string = portalWebUIPicture.getFileId();
                jsonGenerator.writeStringField("fileId", string);
                String string2 = this.r.getPictureBase64FileFromGridfs(string);
                jsonGenerator.writeStringField("fileData", string2);
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
    }

    private void s(JsonGenerator jsonGenerator) throws IOException {
        List list = this.a.findAll(Map.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            jsonGenerator.writeObjectField("map", (Object)list);
            jsonGenerator.writeArrayFieldStart("mapFile");
            for (Map map : list) {
                String string = map.getFileId();
                if (null == string) continue;
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("fileId", string);
                String string2 = this.r.getPictureBase64FileFromGridfs(string);
                if (null == string2) continue;
                jsonGenerator.writeStringField("fileData", string2);
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
    }

    private void t(JsonGenerator jsonGenerator) throws IOException {
        Object object = this.s.getCloudKeyConfig(null, null).getResult();
        if (null != object && object instanceof CloudKeyEntry) {
            CloudKeyEntry cloudKeyEntry = (CloudKeyEntry)object;
            jsonGenerator.writeObjectField("cloudKey", (Object)cloudKeyEntry);
        }
    }

    private void a(JsonGenerator jsonGenerator, int n2, long l2) throws IOException {
        int n3;
        long l3;
        Query query = new Query();
        if (!this.a(n2)) {
            query.addCriteria(Criteria.where((String)"end").gte((Object)(this.a(n2, l2) / 1000L)));
        }
        if (0L == (l3 = this.a.count(query, Guest.class))) {
            return;
        }
        long l4 = l3 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("authInfo");
        int n4 = 0;
        while ((long)n4 < l4 && 0 != (n3 = Math.min(1000, (int)(l3 - (long)(n4 * 1000))))) {
            query.with((Pageable)new PageRequest(n4, Math.min(1000, n3)));
            List list = this.a.find(query, Guest.class);
            for (Guest guest : list) {
                jsonGenerator.writeObject((Object)guest);
            }
            ++n4;
        }
        jsonGenerator.writeEndArray();
    }

    private void b(JsonGenerator jsonGenerator, int n2, long l2) throws IOException {
        int n3;
        long l3;
        Query query = new Query();
        if (!this.a(n2)) {
            query.addCriteria(Criteria.where((String)"lastSeen").gte((Object)this.a(n2, l2)));
        }
        if (0L == (l3 = this.a.count(query, ClientHistory.class))) {
            return;
        }
        long l4 = l3 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("clientHistory");
        int n4 = 0;
        while ((long)n4 < l4 && 0 != (n3 = Math.min(1000, (int)(l3 - (long)(n4 * 1000))))) {
            query.with((Pageable)new PageRequest(n4, Math.min(1000, n3)));
            List list = this.a.find(query, ClientHistory.class);
            for (ClientHistory clientHistory : list) {
                jsonGenerator.writeObject((Object)clientHistory);
            }
            ++n4;
        }
        jsonGenerator.writeEndArray();
    }

    private void a(JsonGenerator jsonGenerator, int n2) throws IOException {
        int n3;
        long l2;
        Query query = new Query();
        if (!this.a(n2)) {
            query.addCriteria(Criteria.where((String)"time").gte((Object)com.tp_link.eap.util.c.a.c((int)n2)));
        }
        if (0L == (l2 = this.a.count(query, LogInfo.class))) {
            return;
        }
        long l3 = l2 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("logs");
        int n4 = 0;
        while ((long)n4 < l3 && 0 != (n3 = Math.min(1000, (int)(l2 - (long)(n4 * 1000))))) {
            query.with((Pageable)new PageRequest(n4, Math.min(1000, n3)));
            List list = this.a.find(query, LogInfo.class);
            for (LogInfo logInfo : list) {
                jsonGenerator.writeObject((Object)logInfo);
            }
            ++n4;
        }
        jsonGenerator.writeEndArray();
    }

    private void b(JsonGenerator jsonGenerator, int n2) throws IOException {
        int n3;
        long l2;
        Query query = new Query();
        if (!this.a(n2)) {
            query.addCriteria(Criteria.where((String)"time").gte((Object)com.tp_link.eap.util.c.a.c((int)n2)));
        }
        if (0L == (l2 = this.a.count(query, AlertInfo.class))) {
            return;
        }
        long l3 = l2 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("alerts");
        int n4 = 0;
        while ((long)n4 < l3 && 0 != (n3 = Math.min(1000, (int)(l2 - (long)(n4 * 1000))))) {
            query.with((Pageable)new PageRequest(n4, Math.min(1000, n3)));
            List list = this.a.find(query, AlertInfo.class);
            for (AlertInfo alertInfo : list) {
                jsonGenerator.writeObject((Object)alertInfo);
            }
            ++n4;
        }
        jsonGenerator.writeEndArray();
    }

    private void c(JsonGenerator jsonGenerator, int n2, long l2) throws IOException {
        int n3;
        long l3;
        Query query = new Query();
        if (!this.a(n2)) {
            query.addCriteria(Criteria.where((String)"daytime").gte((Object)this.a(n2, l2)));
        }
        if (0L == (l3 = this.a.count(query, StatRAHourly.class))) {
            return;
        }
        long l4 = l3 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("raHourly");
        int n4 = 0;
        while ((long)n4 < l4 && 0 != (n3 = Math.min(1000, (int)(l3 - (long)(n4 * 1000))))) {
            query.with((Pageable)new PageRequest(n4, Math.min(1000, n3)));
            List list = this.a.find(query, StatRAHourly.class);
            for (StatRAHourly statRAHourly : list) {
                jsonGenerator.writeObject((Object)statRAHourly);
            }
            ++n4;
        }
        jsonGenerator.writeEndArray();
    }

    private void d(JsonGenerator jsonGenerator, int n2, long l2) throws IOException {
        int n3;
        long l3;
        Query query = new Query();
        if (!this.a(n2)) {
            query.addCriteria(Criteria.where((String)"daytime").gte((Object)this.a(n2, l2)));
        }
        if (0L == (l3 = this.a.count(query, StatRADaily.class))) {
            return;
        }
        long l4 = l3 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("raDaily");
        int n4 = 0;
        while ((long)n4 < l4 && 0 != (n3 = Math.min(1000, (int)(l3 - (long)(n4 * 1000))))) {
            query.with((Pageable)new PageRequest(n4, Math.min(1000, n3)));
            List list = this.a.find(query, StatRADaily.class);
            for (StatRADaily statRADaily : list) {
                jsonGenerator.writeObject((Object)statRADaily);
            }
            ++n4;
        }
        jsonGenerator.writeEndArray();
    }

    private void e(JsonGenerator jsonGenerator, int n2, long l2) throws IOException {
        int n3;
        long l3;
        Query query = new Query();
        if (!this.a(n2)) {
            query.addCriteria(Criteria.where((String)"lastSeen").gte((Object)this.a(n2, l2)));
        }
        if (0L == (l3 = this.a.count(query, StatLifeClient.class))) {
            return;
        }
        long l4 = l3 / 1000L + 1L;
        jsonGenerator.writeArrayFieldStart("statClient");
        int n4 = 0;
        while ((long)n4 < l4 && 0 != (n3 = Math.min(1000, (int)(l3 - (long)(n4 * 1000))))) {
            query.with((Pageable)new PageRequest(n4, Math.min(1000, n3)));
            List list = this.a.find(query, StatLifeClient.class);
            for (StatLifeClient statLifeClient : list) {
                jsonGenerator.writeObject((Object)statLifeClient);
            }
            ++n4;
        }
        jsonGenerator.writeEndArray();
    }

    private long a(int n2, long l2) {
        long l3 = (long)n2 * 24L * 60L * 60L * 1000L;
        return l2 - l3;
    }

    private boolean a(int n2) {
        return 0 == n2 && com.tp_link.eap.util.l.b();
    }
}

